package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.VdesestimadosAperturas;
import com.ejie.ab04b.service.VdesestimadosAperturasService;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * VdesestimadosAperturasController generated by UDA, 04-ago-2017 12:42:37.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/vdesestimadosaperturas")
public class VdesestimadosAperturasController {

	private static final Logger logger = LoggerFactory
			.getLogger(VdesestimadosAperturasController.class);

	public static final String ATTR_NAME_DESESAPERTURA_FILTER = "vdesestimientoAperturasFiltroModel";

	@Autowired()
	private VdesestimadosAperturasService vdesestimadosAperturasService;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		VdesestimadosAperturasController.logger
				.info("[GET - View] : vdesestimadosaperturas");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);
		return "vdesestimadosaperturas";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterVdesestimadosAperturas
	 *            VdesestimadosAperturas Bean que contiene los parametros de
	 *            filtrado a emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterVdesestimadosAperturas the filter vdesestimados aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<VdesestimadosAperturas> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<VdesestimadosAperturas> filter(
			@RequestJsonBody(param = "filter") VdesestimadosAperturas filterVdesestimadosAperturas,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		VdesestimadosAperturasController.logger
				.info("[POST - filter] : Obtener VdesestimadosAperturass");
		return this.vdesestimadosAperturasService
				.filter(filterVdesestimadosAperturas, jqGridRequestDto, false);
	}

	/**
	 * AÃ±ade al model los datos necesarios para la carga de los combos de la
	 * pantalla del filtro de busqueda.
	 * 
	 *  model            Model
	 *
	 * @param model the model
	 */
	private void precargaCombosFiltroBusqueda(Model model) {

		model.addAttribute("autoridades",
				UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

		VdesestimadosAperturas desestimiento = new VdesestimadosAperturas();

		Calendar c = Calendar.getInstance();
		desestimiento.setAnoExp(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(
				VdesestimadosAperturasController.ATTR_NAME_DESESAPERTURA_FILTER,
				desestimiento);
	}

}
